﻿CREATE OR REPLACE FUNCTION genere_repart_nom() RETURNS TEXT AS $$
       WITH   terme_dico (id_terme_dico,nom_terme_dico,popul,b_inf,b_sup)      
       AS     (VALUES (1,'Martin', 100000,     1, 100000),
                      (2,'Bernard',  50000,100001, 150000),
                      (3,'Dubois',  30000,150001, 180000),
                      (4,'Thomas',  25000,180001,205000),
                      (5,'Robert',22000,205001,227000),
                      (6,'Richard',20000,227001,247000)),
       borne_dico (borne_inf,borne_sup) 
       AS     (SELECT MIN(b_inf),MAX(b_sup) FROM terme_dico), 
              generation_alea (valeur_alea)
       AS     (SELECT TRUNC(RANDOM() * (borne_sup-borne_inf+1))+borne_inf
               FROM   borne_dico)
       SELECT CAST(nom_terme_dico AS TEXT)
       FROM   terme_dico JOIN generation_alea ON valeur_alea>=b_inf 
                                             AND valeur_alea<=b_sup;
$$     LANGUAGE SQL;
WITH   generation_nom (id_nom,nom) AS (
SELECT GENERATE_SERIES,genere_repart_nom() FROM GENERATE_SERIES(1,50000))
SELECT nom AS "Nom généré",COUNT(*) AS "Répartition générée" FROM generation_nom 
GROUP  BY nom ORDER BY 2 DESC;
